#delimit ;
cap log close ;
log using table1.log, text replace ;

cap log close t1out ;
qui log using table1_out.csv , text replace name(t1out) ;
qui log off t1out  ;

clear ;
set more off ;

do set_directory_macros ;

cap prog drop runme ;
prog def runme ;

/***************** MAKE THE DATA SET ****************/
/* generate state policy variable */
use statefip using "${madedat}/CPS_2012_micro_small" , replace ;
contract statefip ;
set seed 10101 ;
generate sort_order = uniform() ;
sort sort_order ;
gen policy = _n <= 25 ;
sort statefip ;
drop sort_order _freq ;
*list ;

tempfile statelist ;
qui save `statelist' ;

/* load up the micro data set, and merge on the fake policy variable */
*use "${madedat}/CPS_2012_micro_small" , replace ;
*use "${madedat}/CPS_2012_micro_medium" , replace ;
use "${madedat}/CPS_2012_micro" , replace ;

sort statefip ;
merge m:1  statefip using `statelist' ;
tab _merge ;
drop _merge ;

/***************** ESTIMATE THE MODELS ****************/

/*column 1 */
reg lnwage policy age age2 yrseduc  ;
local b_ols = _b[policy] ;					/* slope coefficient */
local se_ols_default = _se[policy] ;		/* default standard errors */
local N_ols = e(N) ;						/* number of observations */
predict tab1_resid , resid ;

reg lnwage policy age age2 yrseduc  , robust ;	
estimates store ols_white ;
local se_ols_robust = _se[policy] ;			/* Heteroscedastic robust standard errors */

reg lnwage policy age age2 yrseduc  , cluster(statefip) ;
local se_ols_cluster = _se[policy] ;		/* Cluster robust (cluster on state) standard errors */
local G_ols = e(N_clust) ;					/* Number clusters */

reg lnwage policy age age2 yrseduc  , vce(bootstrap , cluster(statefip) reps(399) seed(10101) ) ;
local se_ols_bootstrap = _se[policy] ;		/* Pairs cluster bootstrap standard errors */



/* what is the range of cluster sizes? */
preserve ;
gen byte one = 1 ;
collapse (sum) clusize = one , by(statefip) ;
summ clusize ;
local clusize_min = r(min) ;
local clusize_max = r(max) ;

restore ;

loneway tab1_resid statefip ;
local rho = r(rho) ; 						/* Intraclass correlation */
di ;
di "intraclass correation = `rho'" ;
/* what else to save? */


/* now do RE models */
/* Column 2, "FGLS (Random Effects)" */
xtset statefip ;
xtreg lnwage policy age age2 yrseduc , re ;
local b_re = _b[policy] ;
local se_re_default = _se[policy] ;
local N_re = e(N) ;


xtreg lnwage policy age age2 yrseduc , re cluster(statefip) ;
local se_re_cluster = _se[policy] ;

/*********************************************/
/* COLIN I CANNOT GET THIS TO CONVERGE IN A SHORT AMOUNT OF TIME with full sample.  
I PROPOSE WE comment it out in the published code */
/* On Doug's work desktop, takes 2 hours to run when using "full" micro sample. */
/* also, for "small" sample, it doesn't yet give the same thing as the regular re model */
/* another way to to random effects model 
(compare with xtreg output)
(not in table)							*/
set matsize 6000 ;
xtreg lnwage policy age age2 yrseduc , pa corr(exch) robust ;
/************ END PROPOSED commenting out *********/

/* Random Effects model with cluster bootstrap for standard errors */
xtreg lnwage policy age age2 yrseduc , re vce(bootstrap , reps(399) seed(10101) ) ;
local se_re_bootstrap = _se[policy] ;

/* next, display output */

qui log on t1out  ;
di ; 
di "OLS" ;
di ; di ;
di "beta,  " 		%8.4f `b_ols' ;
di "se def,"		%8.4f `se_ols_default' ;
di "se rob,"		%8.4f `se_ols_robust' ;
di "se clu,"		%8.4f `se_ols_cluster' ;
di "se boot,"		%8.4f `se_ols_bootstrap' ;
di ;
di "Num obs,"		%8.0f `N_ols' ;
di "Num clusters,"	%8.0f `G_ols' ;
di "Ng range," " `clusize_min' to `clusize_max'" ;
di "Rho, "			%8.3f `rho' ;

di ; 
di "Random effects" ;
di ; 
di ;
di "beta,  " 		%8.4f `b_re' ;
di "se def,"		%8.4f `se_re_default' ;
di "se rob,"		"     -   " ;
di "se clu,"		%8.4f `se_re_cluster' ;
di "se boot,"		%8.4f `se_re_bootstrap' ;
di ;
di "Num obs,"		%8.0f `N_re' ;

qui log off t1out ;
end ;

runme ;
qui log close t1out ;
log close _all ;

